TITLE   'MgO Plate with a Hole, k(T)'				{ exa161.pde }
SELECT     					{ Student Edition }
   errlim=1e-4     ngrid=1     spectral_colors
VARIABLES   temp
DEFINITIONS
   Lx=0.6     Ly=0.4     r0=0.1
   heat=0     k=15000/temp            		{ Thermal conductivity k(T) }
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)
   fluxd=vector( fluxd_x, fluxd_y)     fluxdm=magnitude( fluxd)
INITIAL VALUES
   temp=1300
EQUATIONS
   div( fluxd)=heat
BOUNDARIES
region 'domain'
   start (0,0)  natural(temp)=0  line to (Lx,0) 		{ Insulated }
   value(temp)=300  line to (Lx,Ly)
   natural(temp)=0  line to (0,Ly)
   value(temp)=2300   line to close
   start (Lx/2-r0,Ly/2)  natural(temp)=0			{ Exclude hole }	
   arc (center=Lx/2,Ly/2)  angle=360
MONITORS
   elevation(temp) from (0,0) to (Lx,0)
PLOTS
   contour( temp)     contour( k) painted     vector( fluxd) norm
   contour( fluxd_x)     contour( fluxd_y)     contour( fluxdm)
   elevation( temp) from (0,0) to (Lx,0)
END

